/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package server;

import shared.*;
import java.io.*;

/**
 * This class implements the main Server user interface.  It
 * "wraps" around the Server class and provides an interface for
 * controlling all server duties.
 * 
 * @version 1.0, 3/24/1999
 * @author Jason Howes
 */
public class ServerUI extends Thread
{
	/**
	 * All member variables
	 */
	private boolean mAlive;
	private Server mServer;
	private BufferedReader mInputStream;

	/**
	 * Class constructor.
	 */
	public ServerUI(Server server) throws IOException
	{	
		// Input stream
		mInputStream = new BufferedReader(new InputStreamReader(System.in));

		// Initialize
		mAlive = false;
		mServer = server;
	}

	/**
	 * Thread function.
	 */
	public void run()
	{
		mAlive = true;
		
		while (mAlive) 
		{
			// Next command
			String command;
			
			// Process next command
			try 
			{
				command = "" + mInputStream.readLine();
				
				// Handle startup
				if (command.equals("start"))
				{
					System.out.println("Starting server...");
					try
					{
						mServer.start();
						System.out.println("Server started.\n");
					}
					catch (ServerException e)
					{
						mServer.printDebugString(e);
						System.out.println("Server start failed.\n");
					}
				}
				
				// Handle shutdown
				else if (command.equals("shutdown"))
				{
					System.out.println("Shuting down server...");
					try
					{
						mServer.shutdown();
						System.out.println("Server stopped.\n");
					}
					catch (ServerException e)
					{
						mServer.printDebugString(e);
						System.out.println("Server shutdown failed.\n");
					}					
				}

				// Handle exit
				else if (command.equals("quit")) 
				{
					mAlive = false;
				}
				
				// Get the number of active sessions
				else if (command.equals("sessions")) 
				{
					System.out.println("Number of active sessions: " + mServer.getNumServerSessions() + "\n");
				}
				
				// UNKNOWN
				else
				{
					System.out.println("Unknown command.\n");
				}
			}
			catch (IOException e) 
			{
				// Unknown error, so exit...
				return;
			}
		}

		// Shutdown UI and server
		try
		{
			if (mServer.getServerState())
			{
				mServer.shutdown();
				System.out.println("Server stopped.");				
			}
		}
		catch (ServerException e)
		{
				mServer.printDebugString(e);
				System.out.println("Server shutdown failed.");				
		}
		
		System.out.println("User interface stopped.");
		System.exit(0);
	}
}